extern const unsigned char pantallas[];	//screens


extern const unsigned char tiles[];	//Pointer to tiles in the library
extern const unsigned char tiles_set1[];	//Pointer to self tiles

extern const unsigned char tiles_comp4[];	//Pointer to self tiles
extern const unsigned char tiles_comp6[];	//Pointer to self tiles

void init_keyboard()
{

	cpc_AssignKey (KEY_ESC, 0x4804);		// ESC

}


void load_tilemap(void)
{

            memcpy(tiles,tiles_set1,TILESET_LENGHT);  // 0-12 = 13 tiles
            memcpy(tiles+TILESET_LENGHT,tiles_comp4,256);  // 10 tiles -- PArty control
            memcpy(tiles+TILESET_LENGHT+320,tiles_comp6,64);  // 4 tiles --  Trash Container



}

void draw_tilemap()
{
    int index;
    unsigned char x,y,val,val1,val2,val3,val4;
    //set the tiles of the map. In this example, the tile map is 32x16 tile
    //Tile Map configuration file: TileMapConf.asm


    index=maptable_offset;
    for(y=0; y<20; y=y+2)
        {
        for (x=0; x<32; x=x+2)
        {
            val=val1=val2=val3=val4=pantallas[index];

             switch(val)
                {
                    case 0:
                    case 1:                             // Floor & Teleporters
                    case 2:
                    case 5:
                    case 41:    val1=val2=val3=val4=0;
                                break;
                    case 6:    pendrive_x=x*2;
                               pendrive_y=y*8;
                               pendrive_vis=0;
                               val1=val2=val3=val4=0;
                                break;


                    case 11:    val1=val2=val3=val4=1;  // Solid wall A
                                break;

                    case 12:    val1=val2=val3=val4=2;  // Solid wall B
                                break;
                    case 13:    val1=val2=val3=val4=13;   // Solid test
                                break;

                    case 14:    val1=7;  //mesa Iz + Portatil
                                val2=8;
                                val3=3;
                                val4=4;
                                break;

                    case 15:    val1=9;  //mesa De + Sobremesa
                                val2=10;
                                val3=5;
                                val4=6;
                                break;

                    case 16:    val1=9;  //mesa Iz + Sobremesa
                                val2=10;
                                val3=3;
                                val4=4;
                                break;

                    case 17:    val1=7; //mesa De + Portatil
                                val2=8;
                                val3=5;
                                val4=6;
                                break;

                    case 18:    val1=11;  //mesa Iz + Plasmon
                                val2=12;
                                val3=3;
                                val4=4;
                                break;

                    case 19:    val1=11;  //mesa De + Plasmon
                                val2=12;
                                val3=5;
                                val4=6;
                                break;

                    case 31:    val1=15;
                                val2=16;
                                val3=17;
                                val4=18;
                                break;
                    case 8:    val1=0;
                                val2=19;
                                val3=0;
                                val4=20;
                                break;
                    case 32:    val1=21;
                                val2=22;
                                val3=23;
                                val4=24;
                                break;
                    case 9:    val1=25;
                                val2=0;
                                val3=26;
                                val4=0;
                                break;
                    case 33:    val1=13;
                                val2=13;
                                val3=14;
                                val4=14;
                                break;
                    case 34:    val1=13;
                                val2=13;
                                val3=13;
                                val4=13;
                                break;
                    case 35:    val1=33;
                                val2=33;
                                val3=34;
                                val4=34;
                                break;
                    case 36:    val1=35;
                                val2=35;
                                val3=36;
                                val4=36;
                                break;
                    case 37:    val1=27;
                                val2=35;
                                val3=28;
                                val4=36;
                                break;

               }


            cpc_SetTile(x,y,val1);
            cpc_SetTile(x+1,y,val2);
            cpc_SetTile(x,y+1,val3);
            cpc_SetTile(x+1,y+1,val4);
            index++;
        }
    }


}



void datatiles(void)
{
__asm

// Tiles de 2x8 bytes

_tiles_set1: //Party place   -- 13 tiles (0-12)
;tile 0  //suelo Azul
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0

;tile 1 //pared horizontal
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC

;tile 2 //pared vertical
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44

;tile 3 //A21 MESAizqu1
.db  #0xC0,#0xE8
.db  #0xC0,#0xAC
.db  #0xC0,#0xAC
.db  #0xD4,#0x84
.db  #0xD4,#0x84
.db  #0xD4,#0x84
.db  #0xD4,#0x84
.db  #0xD4,#0x84

;tile 4 //A22 MESAizqu2
.db  #0x0C,#0xC0
.db  #0x0C,#0x48
.db  #0x0C,#0x48
.db  #0x0C,#0x48
.db  #0x0C,#0x48
.db  #0xC0,#0x48
.db  #0xC0,#0x48
.db  #0xC0,#0x48

;tile 5 //B21 MESAdere1
.db #0xC0,#0x0C
.db #0x84,#0x0C
.db #0x84,#0x0C
.db #0x84,#0x0C
.db #0x84,#0x0C
.db #0x84,#0xC0
.db #0x84,#0xC0
.db #0x84,#0xC0

;tile 6 //B21 MESAdere1
.db #0xD4,#0xC0
.db #0x5C,#0xC0
.db #0x5C,#0xC0
.db #0x48,#0xE8
.db #0x48,#0xE8
.db #0x48,#0xE8
.db #0x48,#0xE8
.db #0x48,#0xE8

;tile 7 //A11 Portatil
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xFC,#0xFC

;tile 8 //A12 Portatil
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xCC,#0xC0
.db  #0x6E,#0xC0
.db  #0xCC,#0xC0
.db  #0xC4,#0xC0
.db  #0xFC,#0xFC

;tile 9 //B11 PC sobremesa1
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xCC
.db #0xC0,#0x9D
.db #0xC0,#0x9D
.db #0xC0,#0xCC
.db #0xC0,#0xC4
.db #0xFC,#0xFC

;tile 10 //B12 PC sobremesa2
.db #0xC0,#0xC0
.db #0xC0,#0x4C
.db #0xCC,#0x4C
.db #0x6E,#0x4C
.db #0x6E,#0x19
.db #0xCC,#0x0C
.db #0xC8,#0x0C
.db #0xFC,#0xFC

;tile 11 //C11 Pantalla consola1
.db #0xC4,#0xCC
.db #0xC4,#0xC0
.db #0xC4,#0xC0
.db #0xC4,#0xC0
.db #0xC4,#0xC0
.db #0xC4,#0xCC
.db #0xC0,#0xCC
.db #0xFC,#0xFC

;tile 12 //C12 Pantalla consola2
.db #0xCC,#0xC8
.db #0xC0,#0xC8
.db #0xC0,#0xC8
.db #0xC0,#0xC8
.db #0xC0,#0xC8
.db #0xCC,#0xC8
.db #0xCC,#0x00
.db #0xFC,#0xFC


_tiles_comp4:  //Party main control

//Morro escenario

.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00

//blanco borde
.db  #0xCC,#0xCC
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0xCC,#0xCC

////baranda iz,,

//1
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC4
.db  #0xC0,#0xCC
.db  #0xC0,#0xCC
.db  #0xC4,#0xC4
.db  #0xC4,#0xC4
.db  #0xC4,#0xCC
//2
.db  #0xC4,#0x88
.db  #0xC8,#0x88
.db  #0xC0,#0x88
.db  #0xC4,#0x88
.db  #0xC8,#0x88
.db  #0xC0,#0x88
.db  #0xC4,#0x88
.db  #0xCC,#0x88
//3
.db  #0xC4,#0xC4
.db  #0xC4,#0xC4
.db  #0xC4,#0xC8
.db  #0xC4,#0xC8
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
//4
.db  #0xC8,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88

//Lat IZ
//1,3
//Usar tile 0
//2
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
//4
.db  #0xC0,#0xcc
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0xCC

//baranda DE,,

//1
.db  #0x44,#0xC8
.db  #0x44,#0xC4
.db  #0x44,#0xC0
.db  #0x44,#0xC8
.db  #0x44,#0xC4
.db  #0x44,#0xC0
.db  #0x44,#0xC8
.db  #0x44,#0xCC
//2
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC8,#0xC0
.db  #0xCC,#0xC0
.db  #0xCC,#0xC0
.db  #0xC8,#0xC8
.db  #0xC8,#0xC8
.db  #0xCC,#0xC8
//3
.db  #0x44,#0xC4
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
//4
.db  #0xC8,#0xC8
.db  #0xC8,#0xC8
.db  #0xC4,#0xC8
.db  #0xC4,#0xC8
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0

//lar DE,,
//1
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
//3
.db  #0xCC,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0xCC,#0xC0
//2,4
//Usar tile 0
//back+org
//
.db #0x48,#0xC0
.db #0x0C,#0x84
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0xC8,#0xC4
.db #0xC8,#0xC4
.db #0x9C,#0x6C
//
.db #0x9C,#0x6C
.db #0xD8,#0xE4
.db #0x58,#0xF0
.db #0x0C,#0xA4
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C


_tiles_comp6:
//Control panel
//27
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
//28
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x84,#0x0C
.db #0xC0,#0x48
//back
//29
.db #0x48,#0xC0
.db #0x0C,#0x84
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC

//30
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0x4C,#0xCC
.db #0x0C,#0x8C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C



__endasm;

}






void datamap(void)
{
__asm

_pantallas:

//11  ENDING SCENE
.DB #11,#11,#11,#11,#11,#11,#11,#11,#11,#11,#11,#11,#11,#11,#11,#11
.DB #11,#11,#11,#00,#00,#00,#00,#00,#11,#11,#11,#11,#11,#11,#11,#11
.DB #11,#11,#11,#00,#00,#00,#00,#00,#11,#11,#11,#11,#11,#11,#11,#11
.DB #11,#11,#11,#00,#00,#00,#00,#00,#11,#11,#11,#11,#11,#11,#11,#11
.DB #11,#11,#11,#00,#00,#00,#00,#00,#11,#11,#11,#11,#11,#11,#11,#11
.DB #11,#11,#11,#11,#11,#11,#11,#11,#11,#11,#11,#11,#01,#11,#11,#11
.DB #36,#36,#31,#34,#34,#34,#34,#34,#32,#37,#36,#36,#00,#00,#00,#00
.DB #35,#35,#08,#33,#33,#33,#33,#33,#09,#35,#35,#35,#00,#00,#00,#00
.DB #00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00,#00
.DB #17,#14,#19,#14,#17,#16,#15,#00,#00,#16,#17,#14,#15,#14,#15,#16

_tintas:  //firmware inks
    .db #0,#1,#26,#13,#3,#6,#24,#15,#17,#18,#2,#16,#9,#19,#11,#25

__endasm;
}


